#!/usr/bin/perl
use strict;
use warnings;
use Encode;
use Unicode::Normalize qw(normalize);

use LWP::Simple qw(get);

binmode STDOUT, ":utf8";

sub trim($)
{
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}

sub last8($)
{
    my $string = shift;
    $string =~ /.*(........)/;
    return $1;
}

sub getReleaseDate($) 
{
    my $url = shift;
    $url .= "/?of=7";
    
    my $page = get "$url";
    if ($page =~ /<h1>.*?Released: (.*?)</) {
	my $date = $1;
	$date =~ /(\d*)\/(\d*)\/(\d*)/;
	my $newDate = sprintf("%04d/%02d/%02d", $3, $1, $2);
	return $newDate;
    }
    return "N/A";
}

my @timeData = localtime(time);
my $year = 1900 + $timeData[5];
my $month = $timeData[4] + 1;
my $day = $timeData[3];
printf ("$year-%02d-%02d\n",$month,$day);

print <<MISSING_TITLES;
58410842,2007/09/05,2.50,691,Cyberball 2072
58410823,2006/11/15,2.50,912,Defender
584107df,2005/10/03,2.50,3658,Gauntlet
584107d8,2005/10/03,2.50,2602,Joust
58410829,2007/02/14,3.00,2770,Paperboy
584107e0,2005/10/03,2.50,2501,Robotron: 2084
5841082d,2007/02/07,3.00,1507,Root Beer Tapper
584107e1,2005/10/03,3.00,3414,Smash TV
58410833,2006/10/22,3.50,14439,Ultimate MK3
MISSING_TITLES


my $page_num = 1;
my $page = get "http://marketplace.xbox.com/en-US/games/catalog.aspx?d=6&r=-1&g=-1&mt=16&ot=0&sb=0&rl=0&p=$page_num";

my $continue = 1;
my $last_page = 0;

while ($continue) {
    my $i = 1;

#    print $page."\n";
    while ($page =~ /<\/div><p class="XbcMktGameItemThumbnailTitle"><a href="(.*?)\/">(.*?)<\/a><\/p><\/div.*?AverageRating_(\d*).png.*?class="ratingcount">(\d*)<\/span>/g) {
#	print $page;
	
	my $url = $1;
	my $title = $2;
	my $rating = $3;
	my $ratingCount = $4;
	my $id = last8(trim($url));

#	$title = encode('ascii', normalize('KD', $title), sub { $_[0]='' });

	my $releaseDate = getReleaseDate($url);

	$rating = (5 * $rating)/ 20;

#	print "$id,$releaseDate,$rating,$ratingCount,".trim($title)."\n";
	print "$id,$releaseDate,";
	printf ("%0.2f",$rating);
	print ",$ratingCount,".$title."\n";

##	if (lc($id) eq '5841081a') {  # add duplicate super contra
##	    $id = '584108cc';
##	    print "$id,$releaseDate,$rating,$ratingCount,".trim($title)."\n";
##	}

	if (lc($id) eq '58410820') {  # add duplicate buku sudoku
	    $id = '5841091e';
	    print "$id,$releaseDate,$rating,$ratingCount,".trim($title)."\n";
	}

	if (lc($id) eq '584109a7') {  # add duplicate wolfenstein 3d
	    $id = '584109cb';
	    print "$id,$releaseDate,$rating,$ratingCount,".trim($title)."\n";
	}
    }

    $page_num++;
    $page = get "http://marketplace.xbox.com/en-US/games/catalog.aspx?d=6&r=-1&g=-1&mt=16&ot=0&sb=0&rl=0&p=$page_num";

    if ($last_page == 1) {
	$continue = 0;
    }
    $page =~ /\d*-(\d*) of (\d*) results/;
    if ($1 eq $2) {
	$last_page = 1;
    }
}    



